package gov.va.genisis2.ts.common.dto;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import gov.va.genisis2.ts.objectmapper.EscapeHtmlSerializer;

/**
 * Data Transfer Object for bookmark entities
 * 
 * @author Michael Edoror
 */
public class BookmarkDTO implements Serializable {

	private static final long serialVersionUID = 1L;

	private int bookmarkId;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String conceptUri;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String username;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String conceptName;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String conceptNameWithOntologyName;
	private List<LabelDTO> labels;
	private Boolean hasMapping;

	/**
	 * @return the bookmarkId
	 */
	public int getBookmarkId() {
		return bookmarkId;
	}

	/**
	 * @param bookmarkId
	 *            the bookmarkId to set
	 */
	public void setBookmarkId(int bookmarkId) {
		this.bookmarkId = bookmarkId;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri
	 *            the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username
	 *            the username to set
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return the conceptName
	 */
	public String getConceptName() {
		return conceptName;
	}

	/**
	 * @param conceptName
	 *            the conceptName to set
	 */
	public void setConceptName(String conceptName) {
		this.conceptName = conceptName;
	}

	/**
	 * @return the conceptNameWithOntologyName
	 */
	public String getConceptNameWithOntologyName() {
		return conceptNameWithOntologyName;
	}

	/**
	 * @param conceptNameWithOntologyName
	 *            the conceptNameWithOntologyName to set
	 */
	public void setConceptNameWithOntologyName(String conceptNameWithOntologyName) {
		this.conceptNameWithOntologyName = conceptNameWithOntologyName;
	}

	/**
	 * @return the labels
	 */
	public List<LabelDTO> getLabels() {
		return labels;
	}

	/**
	 * @param labels
	 *            the labels to set
	 */
	public void setLabels(List<LabelDTO> labels) {
		this.labels = labels;
	}

	/**
	 * @return the hasMapping
	 */
	public Boolean getHasMapping() {
		return hasMapping;
	}

	/**
	 * @param hasMapping
	 *            the hasMapping to set
	 */
	public void setHasMapping(Boolean hasMapping) {
		this.hasMapping = hasMapping;
	}
}
